
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  Control_SPI.c: functions to communicate with other chips on the PCB using SPI
  Written by Nicholas Vinen, 2012-2013
*/

#include "SPI.h"
#include "p33Fxxxx.h"

void SPI_Setup() {
  LATDbits.LATD0 = 1;
  LATDbits.LATD1 = 1;
  LATCbits.LATC2 = 1;
  TRISDbits.TRISD0 = 0;
  TRISDbits.TRISD1 = 0;
  TRISCbits.TRISC2 = 0;
  AD1PCFGHbits.PCFG17 = 1;
  SPI2CON1bits.PPRE = 2;
  SPI2CON1bits.SPRE = 6;
  SPI2CON1bits.MSTEN = 1;
  SPI2CON1bits.CKP = 1;
  SPI2CON1bits.MODE16 = 1;
  SPI2STATbits.SPIEN = 1;
}

void SPI_Set_Word_Length(unsigned char len) {
  SPI2STATbits.SPIEN = 0;
  SPI2CON1bits.MODE16 = (len == 16);
  SPI2STATbits.SPIEN = 1;
}

unsigned short SPI_Transfer_Word(unsigned short word) {
  IFS2bits.SPI2IF = 0;
  SPI2STATbits.SPIRBF = 0;
  SPI2BUF = word;
  while( !IFS2bits.SPI2IF )
    ;
  return SPI2BUF;
}
